﻿___TERMS_OF_SERVICE___

By creating or modifying this file you agree to Google Tag Manager's Community
Template Gallery Developer Terms of Service available at
https://developers.google.com/tag-manager/gallery-tos (or such other URL as
Google may provide), as modified from time to time.


___INFO___

{
  "type": "TAG",
  "id": "cvt_temp_public_id",
  "version": 1,
  "securityGroups": [],
  "displayName": "ClickPatrol - Tag",
  "categories": ["ANALYTICS", "ADVERTISING"],
  "brand": {
    "id": "brand_dummy",
    "displayName": "",
    "thumbnail": "data:image/png;base64,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\u003d"
  },
  "description": "Clean data without invalid traffic drives smarter decisions. Trusted by over 1500 businesses. ClickPatrol cleans your ad data and blocks fake clicks so every decision is based on truth, not guesswork. Get started in under a minute.",
  "containerContexts": [
    "WEB"
  ]
}


___TEMPLATE_PARAMETERS___

[
  {
    "type": "TEXT",
    "name": "uid",
    "displayName": "ClickPatrol UID",
    "simpleValueType": true,
    "valueHint": "e.g. 9A9046CB-1BD3-4D41-8EE6-9CE06882054S",
    "alwaysInSummary": true,
    "help": "Get your UID from the ClickPatrol dashboard.",
    "valueValidators": [
      {
        "type": "NON_EMPTY"
      }
    ]
  }
]


___SANDBOXED_JS_FOR_WEB_TEMPLATE___

// Get the UID from the url
const uid = data.uid;

// Get parameters from the url
const getUrl = require('getUrl');
const currentUrl = getUrl();

// Get the base url
const baseUrl = 'https://trck-002.clckptrl.com/?uid=' + uid;

// Extract query string from current URL
let fullUrl = baseUrl;
const questionMarkIndex = currentUrl.indexOf('?');

if (questionMarkIndex !== -1) {
  // Get everything after the first ?
  const queryString = currentUrl.substring(questionMarkIndex + 1);
  
  if (queryString && queryString.length > 0) {
    fullUrl = baseUrl + '&' + queryString;
  }
}

// Get the documents
const injectScript = require('injectScript');
injectScript(fullUrl, data.gtmOnSuccess, data.gtmOnFailure, 'clickpatrol-script');


___WEB_PERMISSIONS___

[
  {
    "instance": {
      "key": {
        "publicId": "inject_script",
        "versionId": "1"
      },
      "param": [
        {
          "key": "urls",
          "value": {
            "type": 2,
            "listItem": [
              {
                "type": 1,
                "string": "https://trck-002.clckptrl.com/?uid\u003d*"
              }
            ]
          }
        }
      ]
    },
    "clientAnnotations": {
      "isEditedByUser": true
    },
    "isRequired": true
  }
]



___TESTS___

scenarios: []


___NOTES___

Created on 30-4-2024 13:22:09


